<?php

namespace App\Http\Controllers;

use App\Http\Requests\ExpenseRequest;
use App\Models\Expense;
use Auth;
use Illuminate\Http\Request;

class ExpenseController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        if ($request->has('search')) {
            $keyword = $request->input('search');
            $paginate = false;
            $expenses = Expense::where('name', 'LIKE', '%' . $keyword . '%')
                ->with('transaction')
                ->orderBy('id', 'DESC')->get();

            return view('expense.list', compact('expenses', 'paginate'));
        } else {
            $paginate = true;
            $expenses = Expense::with('transaction')->orderBy('id', 'DESC')->paginate(10)->onEachSide(0);
            return view('expense.list', compact('expenses', 'paginate'));
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('expense.create');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Expense $expense)
    {
        return view('expense.edit', compact('expense'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ExpenseRequest $request)
    {
        $expense = new Expense();
        $expense->name = $request->input('name');
        $expense->save();

        $expense->transaction()->create([
            'amount' => (double) $request->input('amount'),
            'fee' => 0,
            'dr_cr' => 'dr',
            'date' => $request->input('date'),
            'method' => 'online',
            'note' => $request->input('description'),
            'created_user_id' => Auth::user()->id,
            'type' => 'expense'
        ]);

        return back()->with('success', 'Saved successfully');
    }


    /**
     * Update the specified resource in storage.
     */
    public function update(ExpenseRequest $request, Expense $expense)
    {
        $expense = Expense::find($expense->id);
        $expense->name = $request->input('name');
        $expense->save();

        $expense->transaction()->update([
            'amount' => (double) $request->input('amount'),
            'date' => $request->input('date'),
            'note' => $request->input('description'),
        ]);

        return redirect()->route('expense.index')->with('success', 'Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Expense $expense)
    {
        $expense->delete();
        $expense->transaction->delete();
        return redirect()->route('expense.index')->with('success', 'Deleted successfully');
    }
}